TITLE   'Tube with Cooling Flanges'				{ exa154.pde }
SELECT     errlim=3e-5     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r','z')
VARIABLES   temp
DEFINITIONS
   r1=100e-3     r2=120e-3    r3=200e-3     L=5e-2     dL=0.5e-2         	
   temp2=300     heat=0     k=45         			{ Steel }
   fluxd_r=-k*dr(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_r, fluxd_z)     fluxdm=magnitude( fluxd)
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain'
   start (r1,0)  natural(temp)=0   line to (r2,0)  		{ Insulated }
   natural( temp)=20*(temp-temp2)
   line to (r2,L)  to (r3,L)  to (r3,L+dL)  to (r2,L+dL)  to (r2,2*L+dL)
   natural( temp)= 0 line to (r1,2*L+dL)
   value( temp)=373 line to close				{ Inside tube }
feature								{ Cooling surface }
   start 'outer' (r2,0)
   line to (r2,L) to (r3,L) to (r3,L+dL) to (r2,L+dL) to (r2,2*L+dL)
PLOTS
   contour( temp) painted     surface( temp)
   vector( fluxd) norm     contour( fluxdm) painted	
   contour( fluxd_r) painted     contour( fluxd_z) painted  	
   elevation( normal( fluxd)) on 'outer'	
   elevation( fluxd_r) from (r1,2*L+dL) to (r1,0)		
END

